<?php
require_once '../config/database.php';

// Get JSON input
$input = json_decode(file_get_contents('php://input'), true);

// Validate input
if (!isset($input['email']) || empty($input['email'])) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => 'Email is required'
    ]);
    exit;
}

$email = filter_var($input['email'], FILTER_VALIDATE_EMAIL);
if (!$email) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => 'Invalid email format'
    ]);
    exit;
}

try {
    $db = getDbConnection();
    
    // Check if user exists but is not verified
    $stmt = $db->prepare("
        SELECT id, is_verified, username 
        FROM users 
        WHERE email = ? 
        AND is_deleted = FALSE
    ");
    $stmt->execute([$email]);
    $user = $stmt->fetch();
    
    if (!$user) {
        // User doesn't exist
        echo json_encode([
            'success' => true,
            'data' => false
        ]);
        exit;
    }
    
    // User exists but not verified (can resend verification)
    if (!$user['is_verified'] || !$user['username']) {
        echo json_encode([
            'success' => true,
            'data' => true
        ]);
    } else {
        // User is fully registered
        echo json_encode([
            'success' => true,
            'data' => false
        ]);
    }
    
} catch (Exception $e) {
    error_log("Check user error: " . $e->getMessage());
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'An error occurred. Please try again.'
    ]);
}
?>