<?php
// File: send_email.php
// Handles sending email using PHPMailer with manual includes.

// Import PHPMailer classes into the global namespace
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

// --- Manually include the required files ---
// Make sure these files are in the SAME directory as send_email.php
require_once 'PHPMailer.php';
require_once 'SMTP.php';
require_once 'Exception.php';

// --- Email Configuration ---
// IMPORTANT: Use environment variables or a secure config file in production!
define('SMTP_HOST', 'smtp.gmail.com');
define('SMTP_PORT', 587); // Port for TLS
define('SMTP_USERNAME', 'chanuxbro@gmail.com'); // <-- Replace with your FULL Gmail address
define('SMTP_PASSWORD', 'tdmb pydc ktps olze');     // <-- Replace with your generated 16-char App Password
define('SMTP_ENCRYPTION', PHPMailer::ENCRYPTION_STARTTLS); // Use TLS encryption
define('FROM_EMAIL', 'chanuxbro@gmail.com');    // <-- Replace with your Gmail address (often same as Username)
define('FROM_NAME', 'Ensi.lk Team 🌟'); // Updated Sender Name
define('BCC_EMAIL', 'chanuxbro@gmail.com');

/**
 * Sends an email using Google SMTP via PHPMailer.
 *
 * @param string $toEmail The recipient's email address.
 * @param string $subject The email subject.
 * @param string $bodyHTML The HTML content of the email.
 * @param string $bodyText Optional plain text version of the email body.
 * @return bool True on success, false on failure.
 */
function sendEnsilkEmail(string $toEmail, string $subject, string $bodyHTML, string $bodyText = ''): bool {
    $mail = new PHPMailer(true); // Enable exceptions

    try {
        // Server settings
        // $mail->SMTPDebug = SMTP::DEBUG_SERVER; // Enable for detailed error output if needed
        $mail->isSMTP();
        $mail->Host       = SMTP_HOST;
        $mail->SMTPAuth   = true;
        $mail->Username   = SMTP_USERNAME;
        $mail->Password   = SMTP_PASSWORD; // Use App Password
        $mail->SMTPSecure = SMTP_ENCRYPTION;
        $mail->Port       = SMTP_PORT;
        $mail->CharSet    = 'UTF-8'; // Essential for Sinhala

        // Recipients
        $mail->setFrom(FROM_EMAIL, FROM_NAME);
        $mail->addAddress($toEmail); // Add a recipient
        $mail->addBCC(BCC_EMAIL);    // Add the BCC address

        // Content
        $mail->isHTML(true);
        $mail->Subject = $subject; // Subject is passed as a parameter
        $mail->Body    = $bodyHTML; // HTML Body is passed as a parameter
        if (!empty($bodyText)) {
            $mail->AltBody = $bodyText; // Plain text version
        } else {
            // Auto-generate plain text from HTML, stripping tags
            $mail->AltBody = strip_tags(str_replace('<br>', "\n", $bodyHTML));
        }

        $mail->send();
        error_log("Email sent successfully to: " . $toEmail . " (BCC: " . BCC_EMAIL . ")");
        return true;
    } catch (Exception $e) {
        // Log the detailed error to PHP's error log
        error_log("Mailer Error [{$toEmail}]: {$mail->ErrorInfo}");
        return false;
    }
}

/**
 * Send verification code email
 */
function sendVerificationEmail(string $email, string $code): bool {
    $subject = "Ensi.lk - Email Verification Code";
    
    $bodyHTML = '
    <!DOCTYPE html>
    <html>
    <head>
        <meta charset="UTF-8">
        <style>
            body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
            .container { max-width: 600px; margin: 0 auto; padding: 20px; }
            .header { background: linear-gradient(135deg, #6C63FF, #00D2FF); color: white; padding: 30px; text-align: center; border-radius: 10px 10px 0 0; }
            .content { background: #f9f9f9; padding: 30px; border-radius: 0 0 10px 10px; }
            .code { background: #fff; border: 2px solid #6C63FF; padding: 20px; text-align: center; font-size: 24px; font-weight: bold; letter-spacing: 5px; margin: 20px 0; border-radius: 8px; }
            .footer { text-align: center; margin-top: 20px; font-size: 12px; color: #666; }
        </style>
    </head>
    <body>
        <div class="container">
            <div class="header">
                <h1>🌟 Ensi.lk</h1>
                <p>Your Digital Experience</p>
            </div>
            <div class="content">
                <h2>Email Verification</h2>
                <p>Thank you for joining Ensi.lk! To complete your registration, please enter the verification code below:</p>
                
                <div class="code">' . $code . '</div>
                
                <p>This code will expire in 10 minutes for security reasons.</p>
                <p>If you didn\'t request this verification, please ignore this email.</p>
                
                <p>Welcome to the Ensi.lk community!</p>
                <p><strong>The Ensi.lk Team</strong></p>
            </div>
            <div class="footer">
                <p>© 2024 Ensi.lk. All rights reserved.</p>
            </div>
        </div>
    </body>
    </html>';

    return sendEnsilkEmail($email, $subject, $bodyHTML);
}

/**
 * Send password reset email
 */
function sendPasswordResetEmail(string $email, string $code): bool {
    $subject = "Ensi.lk - Password Reset Code";
    
    $bodyHTML = '
    <!DOCTYPE html>
    <html>
    <head>
        <meta charset="UTF-8">
        <style>
            body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
            .container { max-width: 600px; margin: 0 auto; padding: 20px; }
            .header { background: linear-gradient(135deg, #FF6B6B, #FF8E8E); color: white; padding: 30px; text-align: center; border-radius: 10px 10px 0 0; }
            .content { background: #f9f9f9; padding: 30px; border-radius: 0 0 10px 10px; }
            .code { background: #fff; border: 2px solid #FF6B6B; padding: 20px; text-align: center; font-size: 24px; font-weight: bold; letter-spacing: 5px; margin: 20px 0; border-radius: 8px; }
            .footer { text-align: center; margin-top: 20px; font-size: 12px; color: #666; }
        </style>
    </head>
    <body>
        <div class="container">
            <div class="header">
                <h1>🔒 Password Reset</h1>
                <p>Ensi.lk Security</p>
            </div>
            <div class="content">
                <h2>Reset Your Password</h2>
                <p>We received a request to reset your password. Use the verification code below to proceed:</p>
                
                <div class="code">' . $code . '</div>
                
                <p>This code will expire in 10 minutes for security reasons.</p>
                <p>If you didn\'t request a password reset, please secure your account and contact support.</p>
                
                <p><strong>The Ensi.lk Security Team</strong></p>
            </div>
            <div class="footer">
                <p>© 2024 Ensi.lk. All rights reserved.</p>
            </div>
        </div>
    </body>
    </html>';

    return sendEnsilkEmail($email, $subject, $bodyHTML);
}

/**
 * Send account deletion confirmation email
 */
function sendAccountDeletionEmail(string $email, string $code): bool {
    $subject = "Ensi.lk - Account Deletion Confirmation";
    
    $bodyHTML = '
    <!DOCTYPE html>
    <html>
    <head>
        <meta charset="UTF-8">
        <style>
            body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
            .container { max-width: 600px; margin: 0 auto; padding: 20px; }
            .header { background: linear-gradient(135deg, #F44336, #FF5722); color: white; padding: 30px; text-align: center; border-radius: 10px 10px 0 0; }
            .content { background: #f9f9f9; padding: 30px; border-radius: 0 0 10px 10px; }
            .code { background: #fff; border: 2px solid #F44336; padding: 20px; text-align: center; font-size: 24px; font-weight: bold; letter-spacing: 5px; margin: 20px 0; border-radius: 8px; }
            .footer { text-align: center; margin-top: 20px; font-size: 12px; color: #666; }
            .warning { background: #fff3cd; border: 1px solid #ffeaa7; padding: 15px; border-radius: 5px; margin: 15px 0; }
        </style>
    </head>
    <body>
        <div class="container">
            <div class="header">
                <h1>⚠️ Account Deletion</h1>
                <p>Ensi.lk Security</p>
            </div>
            <div class="content">
                <h2>Confirm Account Deletion</h2>
                
                <div class="warning">
                    <strong>Warning:</strong> This action cannot be undone. Your account will be permanently removed from our system.
                </div>
                
                <p>To confirm the deletion of your Ensi.lk account, please enter the verification code below:</p>
                
                <div class="code">' . $code . '</div>
                
                <p>This code will expire in 10 minutes for security reasons.</p>
                <p>If you didn\'t request account deletion, please secure your account immediately and contact support.</p>
                
                <p><strong>The Ensi.lk Security Team</strong></p>
            </div>
            <div class="footer">
                <p>© 2024 Ensi.lk. All rights reserved.</p>
            </div>
        </div>
    </body>
    </html>';

    return sendEnsilkEmail($email, $subject, $bodyHTML);
}
?>