<?php
// Test if lessons table exists and has data
require_once 'config.php';

header('Content-Type: application/json');

try {
    $conn = getDBConnection();
    
    if (!$conn) {
        echo json_encode([
            'error' => 'Database connection failed',
            'db_name' => DB_NAME
        ]);
        exit;
    }
    
    // Check if lessons table exists
    $stmt = $conn->query("SHOW TABLES LIKE 'lessons'");
    $tableExists = $stmt->rowCount() > 0;
    
    if (!$tableExists) {
        echo json_encode([
            'error' => 'lessons table does not exist',
            'message' => 'Please import lessons_schema.sql first',
            'db_name' => DB_NAME,
            'instructions' => 'Run: mysql -u ' . DB_USER . ' -p ' . DB_NAME . ' < api/lessons_schema.sql'
        ]);
        exit;
    }
    
    // Check lesson count
    $stmt = $conn->query("SELECT COUNT(*) as count FROM lessons");
    $result = $stmt->fetch();
    $lessonCount = $result['count'];
    
    // Get sample lesson
    $stmt = $conn->query("SELECT id, level, title, has_video, has_audio, has_reading FROM lessons LIMIT 1");
    $sampleLesson = $stmt->fetch();
    
    echo json_encode([
        'success' => true,
        'table_exists' => true,
        'lesson_count' => $lessonCount,
        'sample_lesson' => $sampleLesson,
        'db_name' => DB_NAME
    ], JSON_PRETTY_PRINT);
    
} catch (PDOException $e) {
    echo json_encode([
        'error' => 'Database error',
        'message' => $e->getMessage()
    ], JSON_PRETTY_PRINT);
}
